/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.lotr.recipes.api.utils.LOTRRecipeHandlerUtils;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.VanillaCraftingTableRecipeHandlerSupport;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.ShapedRecipe;
import craftedMods.recipes.base.ShapelessRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.common.item.LOTRPoisonedDrinks;
import lotr.common.recipe.LOTRRecipePoisonWeapon;
import lotr.common.recipe.LOTRRecipesPoisonDrinks;
import lotr.common.recipe.LOTRRecipesTreasurePile;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.tuple.Pair;

@RegisteredHandler
public class LOTRVanillaCraftingTableSupportHandler
implements VanillaCraftingTableRecipeHandlerSupport {
    public Pair<Collection<AbstractRecipe>, Boolean> undefinedRecipeTypeFound(IRecipe recipe) {
        if (recipe instanceof LOTRRecipesPoisonDrinks) {
            return Pair.of(null, (Object)true);
        }
        if (recipe instanceof LOTRRecipePoisonWeapon) {
            return Pair.of(Arrays.asList(LOTRRecipeHandlerUtils.processPoisonWeaponRecipe((LOTRRecipePoisonWeapon)recipe)), (Object)false);
        }
        if (recipe instanceof LOTRRecipesTreasurePile) {
            return this.processTreasurePileRecipe((LOTRRecipesTreasurePile)recipe);
        }
        return null;
    }

    private Pair<Collection<AbstractRecipe>, Boolean> processTreasurePileRecipe(LOTRRecipesTreasurePile recipe) {
        Pair<Block, Item> recipeItems = LOTRRecipeHandlerUtils.getTreasurePileRecipeItems(recipe);
        return Pair.of(Arrays.asList(new ShapedRecipe(1, 1, new Object[]{new ItemStack((Block)recipeItems.getLeft(), 1, 7)}, new ItemStack((Item)recipeItems.getRight(), 4))), (Object)false);
    }

    public int getComplicatedStaticRecipeDepth() {
        return 1;
    }

    public AbstractRecipe loadComplicatedStaticRecipe(ItemStack ... stacks) {
        ItemStack stack = stacks[0];
        PoisonedDrinkRecipe recipe = null;
        if (LOTRPoisonedDrinks.canPoison(stack)) {
            ArrayList<Object> ingredients = new ArrayList<Object>();
            ingredients.add(stack.func_77946_l());
            ingredients.add(LOTRRecipeHandlerUtils.getPoison());
            ItemStack result = stack.func_77946_l();
            LOTRPoisonedDrinks.setDrinkPoisoned(result, true);
            recipe = new PoisonedDrinkRecipe(ingredients, result);
        }
        return recipe;
    }

    public Collection<AbstractRecipe> getDynamicCraftingRecipes(ItemStack result) {
        return Arrays.asList(new AbstractRecipe[0]);
    }

    public Collection<AbstractRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        return Arrays.asList(new AbstractRecipe[0]);
    }

    public boolean matches(ItemStack stack1, ItemStack stack2) {
        return LOTRPoisonedDrinks.isDrinkPoisoned(stack1) == LOTRPoisonedDrinks.isDrinkPoisoned(stack2);
    }

    public class PoisonedDrinkRecipe
    extends ShapelessRecipe {
        public PoisonedDrinkRecipe(List<?> ingredients, ItemStack result) {
            super(ingredients, result);
        }

        public boolean produces(ItemStack result) {
            return LOTRPoisonedDrinks.isDrinkPoisoned(result) ? super.produces(result) : false;
        }

        public boolean consumes(ItemStack ingredient) {
            return !LOTRPoisonedDrinks.isDrinkPoisoned(ingredient) ? super.consumes(ingredient) : false;
        }
    }
}

